/*:
 * @plugindesc 
 * ピクチャの原点の指定方法を追加するプラグイン
 * 
 * @help
 * スクリプトでピクチャを表示するとき、以下のように文字列で原点を指定できる
 * ┌───┬───┐
 * │lt    ct    rt│
 * │              │
 * ├lc    cc    rc┤
 * │              │
 * │lb    cb    rb│
 * └───┴───┘
 * 
 * 
 * 
 * @author ekus
 * @version 1.0
 * 
 * 
 */


Sprite_Picture.prototype.updateOrigin = function () {
	var picture = this.picture();
	switch (picture.origin()) {
		case 0:
			this.anchor.x = 0;
			this.anchor.y = 0;
			break;
		case 1:
			this.anchor.x = 0.5;
			this.anchor.y = 0.5;
			break;


		//-----------------------------
		case "lt": case "tl":
			this.anchor.x = 0;
			this.anchor.y = 0;
			break;

		case "lc": case "cl":
			this.anchor.x = 0;
			this.anchor.y = 0.5;
			break;

		case "lb": case "bl":
			this.anchor.x = 0;
			this.anchor.y = 1;
			break;

		//-----------------------------
		case "ct": case "tc":
			this.anchor.x = 0.5;
			this.anchor.y = 0;
			break;

		case "cc":
			this.anchor.x = 0.5;
			this.anchor.y = 0.5;
			break;

		case "cb": case "bc":
			this.anchor.x = 0.5;
			this.anchor.y = 1;
			break;

		//-----------------------------
		case "rt": case "tr":
			this.anchor.x = 1;
			this.anchor.y = 0;
			break;

		case "rc": case "cr":
			this.anchor.x = 1;
			this.anchor.y = 0.5;
			break;

		case "rb": case "br":
			this.anchor.x = 1;
			this.anchor.y = 1;
			break;


	}
};